/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.ui.misc.HelpAction;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class HelpSupport {
    private static final String HELP_KEY = "org.eclipse.ui.help";

    public static String getHelpContextID(Widget widget) {
        Object data = widget.getData(HELP_KEY);
        return data instanceof String ? (String)data : null;
    }

    public static Action getHelpAction(String contextID) {
        IHelpResource[] resources;
        IContext context;
        if (contextID != null && (context = HelpSystem.getContext((String)contextID)) != null && (resources = context.getRelatedTopics()) != null && resources.length >= 1) {
            return new HelpAction(resources[0].getHref());
        }
        return null;
    }

    public static void addAvailableHelp(Control control, String contextID, IContributionManager mgr) {
        HelpAction action = (HelpAction)HelpSupport.getHelpAction(contextID);
        if (action != null) {
            if (mgr != null) {
                mgr.add((IAction)action);
                mgr.update(false);
            }
            control.addHelpListener((HelpListener)action);
        }
    }

    public static void showHelp(String contextID) {
        IHelpResource[] resources;
        IContext context;
        if (contextID != null && (context = HelpSystem.getContext((String)contextID)) != null && (resources = context.getRelatedTopics()) != null && resources.length >= 1) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(resources[0].getHref());
        }
    }
}

