/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.l10n;

import com.jrockit.mc.components.ui.l10n.LocalizationModel;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class LocaleFileWizardPage
extends WizardPage {
    private final String m_message;
    private final LocalizationModel m_model;
    private String m_selected;

    protected LocaleFileWizardPage(String message, LocalizationModel model) {
        super("localizationSelectionPage");
        this.m_message = message;
        this.m_model = model;
    }

    public void createControl(Composite parent) {
        this.setMessage(this.m_message);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, true, false);
        Label label = new Label(container, 0);
        label.setText(Messages.LOCALIZATION_WIZARD_SELECT_LOCALE_TEXT);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        Combo combo = this.createCombo(container);
        combo.setLayoutData((Object)gd2);
        this.setControl((Control)container);
    }

    private Combo createCombo(Composite parent) {
        final Combo combo = new Combo(parent, 8);
        combo.setVisibleItemCount(15);
        combo.setItems(this.m_model.getAlllocales());
        final String[] all = this.m_model.getAlllocales();
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocaleFileWizardPage.this.m_selected = all[combo.getSelectionIndex()];
            }
        });
        if (combo.getItemCount() > 0) {
            combo.select(0);
            this.m_selected = combo.getItem(0);
        }
        return combo;
    }

    public String getSelected() {
        return this.m_selected;
    }
}

