/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateRepository;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateRepositoryFactory;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.TemplateLabelProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.TemplateProvider;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.wizards.ExportToFileWizardPage;
import java.io.IOException;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class TemplateExportWizard
extends Wizard
implements IExportWizard {
    private static String WIZARD_KEY = "exportTemplateToFile";
    private ExportTemplateToFile m_wizardPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDialogSettings(DialogSettings.getOrCreateSection((IDialogSettings)ControlPanel.getDefault().getDialogSettings(), (String)WIZARD_KEY));
        this.setWindowTitle(Messages.EXPORT_TEMPLATE_WIZARD_TITLE);
        this.m_wizardPage = new ExportTemplateToFile(Messages.EXPORT_TEMPLATE_WIZARD_TITLE);
        this.m_wizardPage.setTitle(Messages.EXPORT_TEMPLATE_WIZARD_TITLE);
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    public boolean performFinish() {
        if (this.m_wizardPage.isExportToFileOk()) {
            try {
                this.m_wizardPage.selected.exportToFile(this.m_wizardPage.getFile());
                this.m_wizardPage.storeFilename();
                return true;
            }
            catch (IOException ioe) {
                DialogToolkit.showExceptionDialogAsync((Display)this.m_wizardPage.getControl().getDisplay(), (String)Messages.IMPORT_EXPORT_TOOLKIT_COULD_NOT_EXPORT_DIALOG_TITLE, (String)NLS.bind((String)Messages.IMPORT_EXPORT_TOOLKIT_COULD_NOT_EXPORT_DIALOG_MESSAGE, (Object)ioe.getLocalizedMessage()), (Throwable)ioe);
            }
        }
        return false;
    }

    private static final class ExportTemplateToFile
    extends ExportToFileWizardPage {
        private IRecordingConfiguration selected;

        private ExportTemplateToFile(String pageName) {
            super(pageName, ".jfc");
        }

        protected Composite createContents(Composite parent) {
            Table table = new Table(parent, 2052);
            TableViewer tv = new TableViewer(table);
            RecordingTemplateRepository repository = TemplateRepositoryFactory.create();
            tv.setContentProvider((IContentProvider)new TemplateProvider());
            tv.setInput((Object)repository);
            tv.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
            tv.setSelection(null);
            tv.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (selectedObject instanceof IRecordingConfiguration) {
                        ExportTemplateToFile.this.selected = (IRecordingConfiguration)selectedObject;
                    } else {
                        ExportTemplateToFile.this.selected = null;
                    }
                    ExportTemplateToFile.this.updatePageComplete();
                }
            });
            return table;
        }

        protected boolean isSelectionValid() {
            return this.selected != null;
        }
    }
}

