/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart.table;

import com.jrockit.mc.common.DataSeries;
import com.jrockit.mc.common.ITimestampedData;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.components.chart.ChartModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.chart.table.ChartTableModel;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ChartTableBuilder
extends ChartModelBuilder<ChartTableModel> {
    private static final int CANCEL_CHECK_EVERY_X = 10000;
    private static final int MAX_TABLE_ROWS = 100000;

    public ChartTableBuilder(IServiceLocator serviceLocator, FLRChartDescriptor chartDescriptor, String name) {
        super(serviceLocator, chartDescriptor, name);
    }

    @Override
    protected ChartTableModel buildModel(IView view, IProgressMonitor monitor) {
        ITimeRange rnage = this.getRange();
        ChartTableModel model = new ChartTableModel();
        if (rnage != null) {
            DataSeries[] dataSeries;
            FLRChartDescriptor chartDescriptor = this.createLocalChartDescriptor();
            if (!this.hasTimeStampXAxis(chartDescriptor)) {
                rnage = this.findRange(this.getRange(), chartDescriptor);
            }
            view.setRange(rnage);
            view.setExpansion(Expansion.NORMAL);
            int index = 0;
            DataSeries[] dataSeriesArray = dataSeries = this.createDataProvider(chartDescriptor.getDataSeriesDescriptors(), chartDescriptor.getXAxis()).getDataSeries();
            int n = dataSeries.length;
            int n2 = 0;
            while (n2 < n) {
                DataSeries dsd = dataSeriesArray[n2];
                model.add(index, this.createList(monitor, (DataSeries<ITimestampedData>)dsd, rnage));
                ++index;
                ++n2;
            }
        }
        return model;
    }

    private List<ITimestampedData> createList(IProgressMonitor monitor, DataSeries<ITimestampedData> ds, ITimeRange tr) {
        ArrayList<ITimestampedData> values = new ArrayList<ITimestampedData>();
        Iterator it = ds.createIterator(tr.getStartTimestamp(), tr.getEndTimestamp());
        int counter = 0;
        while (it.hasNext()) {
            values.add((ITimestampedData)it.next());
            if (counter++ % 10000 == 0 && monitor.isCanceled()) {
                return values;
            }
            if (counter != 100000) continue;
            this.setLastBuildMessage(NLS.bind((String)Messages.TABLE_MODEL_OVERFLOW_TEXT, (Object)this.getComponentName(), (Object)100000));
            return values;
        }
        return values;
    }
}

